<?php
namespace SabaiApps\Directories\Component\View\WordPressBlock;

use SabaiApps\Directories\Component\WordPress\Block\AbstractBlock;
use SabaiApps\Directories\Exception\RuntimeException;

class ViewWordPressBlock extends AbstractBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'json' => true,
            'package' => 'directories',
            'icon' => 'welcome-widgets-menus',
        ];
    }

    public function wordpressBlockEditorVars()
    {
        $views = $groups = $view_options = $default_views = [];
        foreach ($this->_application->getModel('View', 'View')->fetch() as $view) {
            if (!$bundle = $this->_application->Entity_Bundle($view->bundle_name)) continue;

            $groups[$bundle->group] = $bundle->getGroupLabel();
            $k = !empty($bundle->info['is_primary']) ? 0 : (empty($bundle->info['is_taxonomy']) ? 1 : 2);
            $views[$bundle->group][$k][$view->id] =  $bundle->getLabel() . ' - ' . $view->getLabel();
            if ($view->default) $default_views[] = $view->id;
        }
        asort($groups); // sort by group label
        foreach (array_keys($groups) as $group) {
            ksort($views[$group]); // sort by content type
            foreach (array_keys($views[$group]) as $k) {
                asort($views[$group][$k]); // sort by view label
                foreach (array_keys($views[$group][$k]) as $view_id) {
                    $view_options[] = [
                        'value' => $view_id,
                        'label' => $groups[$group] . ' - ' . $views[$group][$k][$view_id],
                    ];
                }
            }
        }

        return [
            'views' => $view_options,
            'default_views' => $default_views,
            'cache_options' => $this->_getCacheOptions(),
        ];
    }

    public function wordpressBlockRender(array $attributes, $content, $isEditor)
    {
        if (empty($attributes['view'])
            || (!$view_id = intval($attributes['view']))
            || (!$view = $this->_application->getModel('View', 'View')->fetchById($view_id))
        ) {
            throw new RuntimeException('Invalid view specified: ' . $attributes['view']);
        }
        $bundle = $this->_application->Entity_Bundle($view->bundle_name, null, '', true);
        $extra_params = [];
        if (isset($attributes['cacheLifetime'])
            && ($attributes['cacheLifetime'] = intval($attributes['cacheLifetime']))
        ) {
            $extra_params['cache'] = $attributes['cacheLifetime'];
        }
        if (!$view->default) {
            if (isset($attributes['queryLimit'])
                && is_numeric($attributes['queryLimit'])
            ) {
                $extra_params['query_limit'] = intval($attributes['queryLimit']);
            }
            if (isset($attributes['queryFields'])
                && strlen($attributes['queryFields'] = trim($attributes['queryFields']))
            ) {
                $extra_params['query_fields'] = $attributes['queryFields'];
            }
        }
        $shortcode = sprintf(
            '[drts-directory-view directory="%s" type="%s" name="%s"%s]',
            $bundle->group,
            $bundle->type,
            $view->name,
            $this->_application->Attr($extra_params)
        );

        return do_shortcode($shortcode);
    }
}